<?php

namespace Orlen\OrlenPaczka\Form\Factory;

use Orlen\OrlenPaczka\Form\Type\GenerateLabelOrderType;
use Orlen\OrlenPaczka\Repository\PackageRepository;
use Symfony\Component\Form\FormFactoryInterface;

class GenerateLabelOrderFormFactory
{
    private FormFactoryInterface $formFactory;
    private PackageRepository $repository;

    public function __construct(FormFactoryInterface $formFactory, PackageRepository $repository)
    {
        $this->formFactory = $formFactory;
        $this->repository = $repository;
    }
    public function factory($idPackage)
    {
        $package = $this->repository->find($idPackage);

        if (!$package) {
            throw new \Exception('Package not found');
        }

        $order = new \Order($package->getIdOrder());

        $customer =  new \Customer($order->id_customer);
        $address =  new \Address($order->id_address_delivery);

        // Pobieramy sender_orders_type z shipment
        $shipment = $package->getShipment();
        $senderOrdersType = $shipment->getSenderOrdersType();

        $pickup = $package->getPickup();

        // Przygotowujemy dane formularza
        $formData = [
            'format' => $package->getShipment()->getLabelFormat(),
            'EMail' => $customer->email,
            'FirstName' => $customer->firstname,
            'LastName' => $customer->lastname,
            'CompanyName' => $address->company,
            'PhoneNumber' => $address->phone,
            'City' => $address->city,
            'PostCode' => $address->postcode,
            'BoxSize' => $package->getShipment()->getSize(),
            'id_order' => $order->id,
            'DestinationPoint' => $pickup->getDestinationCode(),
        ];

        // Dodajemy SenderOrders tylko jeśli sender_orders_type jest równe 0
        $senderOrders = null;
        if ($senderOrdersType === 0) {
            $senderOrders = $shipment->getSenderOrders();
            $formData['SenderOrders'] = $senderOrders;
        }

        return $this->formFactory->create(
            GenerateLabelOrderType::class,
            $formData,
            [
                'sender_orders_type' => $senderOrdersType,
                'sender_orders' => $senderOrders,
                'id_package' => $package->getId(), // Przekazujemy ID paczki do opcji formularza
            ]
        );
    }
}
