<?php

namespace Orlen\OrlenPaczka\Entity;

use Orlen\OrlenPaczka\Repository\SelectedPointRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=SelectedPointRepository::class)
 * @ORM\Table(name=SelectedPoint::TABLE_NAME)
 */
class SelectedPoint
{
    public const TABLE_NAME = _DB_PREFIX_ . 'orlenpaczka_selected_point';
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer", name="id_pickup")
     */
    private $id;

    /**
     * @ORM\Column(type="integer", name="id_cart")
     */
    private $cart;

    /**
     * @ORM\Column(type="integer", name="id_carrier")
     */
    private $carrier;

    /**
     * @ORM\Column(type="string", name="id_point", length=255)
     */
    private $point;

    /**
     * @ORM\Column(type="string", name="destination_code", length=255)
     */
    private $destinationCode;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $address;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $city;

    /**
     * @ORM\Column(type="string", name="postal_code", length=6)
     */
    private $postalCode;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $province;

    /**
     * @ORM\Column(type="float")
     */
    private $latitude;

    /**
     * @ORM\Column(type="float")
     */
    private $longitude;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $name;

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }



    public function getCart(): ?int
    {
        return $this->cart;
    }

    /**
     * @param mixed $cart
     */
    public function setCart(int $cart): void
    {
        $this->cart = $cart;
    }



    public function getCarrier(): ?int
    {
        return $this->carrier;
    }

    public function setCarrier(int $carrier): self
    {
        $this->carrier = $carrier;

        return $this;
    }

    public function getPoint(): ?string
    {
        return $this->point;
    }

    public function setPoint(string $point): self
    {
        $this->point = $point;

        return $this;
    }

    public function getDestinationCode(): ?string
    {
        return $this->destinationCode;
    }

    public function setDestinationCode(string $destinationCode): self
    {
        $this->destinationCode = $destinationCode;

        return $this;
    }

    public function getAddress(): ?string
    {
        return $this->address;
    }

    public function setAddress(string $address): self
    {
        $this->address = $address;

        return $this;
    }

    public function getCity(): ?string
    {
        return $this->city;
    }

    public function setCity(string $city): self
    {
        $this->city = $city;

        return $this;
    }

    public function getPostalCode(): ?string
    {
        return $this->postalCode;
    }

    public function setPostalCode(string $postalCode): self
    {
        $this->postalCode = $postalCode;

        return $this;
    }

    public function getProvince(): ?string
    {
        return $this->province;
    }

    public function setProvince(string $province): self
    {
        $this->province = $province;

        return $this;
    }

    public function getLatitude(): ?float
    {
        return $this->latitude;
    }

    public function setLatitude(float $latitude): self
    {
        $this->latitude = $latitude;

        return $this;
    }

    public function getLongitude(): ?float
    {
        return $this->longitude;
    }

    public function setLongitude(float $longitude): self
    {
        $this->longitude = $longitude;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }
}
