<?php

declare(strict_types=1);

namespace Orlen\OrlenPaczka\Controller\Admin;

use Doctrine\ORM\EntityManagerInterface;
use Orlen\OrlenPaczka\Entity\Shipment;
use Orlen\OrlenPaczka\Form\Handler\ShipmentHandler;
use Orlen\OrlenPaczka\Form\Type\ShipmentType;
use Orlen\OrlenPaczka\Search\Filters\ShipmentFilters;
use Orlen\OrlenPaczka\Tabs\Tab\ShipmentTypeTab;
use Orlen\OrlenPaczka\Tabs\Tabs;
use PrestaShop\PrestaShop\Core\Grid\Presenter\GridPresenterInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Orlen\OrlenPaczka\Translator\Adapter\Translator;

/**
 * @Route(path="/config", name="orlenpaczka.config.shipment")
 */
class ShipmentController extends AbstractController
{
    private Translator $translator;

    public function __construct(Translator $translator)
    {
        $this->translator = $translator;
    }
    /**
     * @Route("/shipment", name=".index", methods={"GET"})
     */

    public function shipmentGridAction(
        \Module $module,
        Request $request,
        Tabs $tabs,
        GridPresenterInterface $gridPresenter,
        ShipmentFilters $filters,
        ShipmentTypeTab $shipmentTypeTab,
        $gridFactory
    )
    {
        $shipmentTypeTab->setActive();
        $grid = $gridPresenter->present($gridFactory->getGrid($filters));

        $toolbars = [ 'add' =>
            [
                'href' => $this->generateUrl('orlenpaczka.config.shipment.add'),
                'desc' => $this->translator->trans('Add new Shipment', [], 'Modules.Waynetsearch.Admin'),
                'icon' => 'settings',
                'class' => 'btn-primary',
            ],
        ];

        return $this->render('@Modules/orlenpaczka/views/templates/admin/config/tabs/shipment_type_grid.html.twig', [
            'layoutTitle' => $module->displayName,
            'layoutHeaderToolbarBtn' => $toolbars,
            'help_link' => false,
            'tabs' => $tabs,
            'grid' => $grid,
            'title' => $this->translator->trans('Shipment', [], 'Modules.Orlenpaczka.Tab'),
        ]);
    }

    /**
     * @Route("/shipment/add", name=".add", methods={"GET", "POST"})
     */
    public function shipmentAddAction(
        \Module $module,
        Request $request,
        Tabs $tabs,
        ShipmentTypeTab $shipmentTypeTab,
        ShipmentHandler $shipmentHandler
    )
    {
        $shipmentTypeTab->setUrl($this->generateUrl('orlenpaczka.config.shipment.add'));
        $shipmentTypeTab->setActive();
        $entity = new Shipment();

        $form = $this->createForm(ShipmentType::class, $entity);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            try{
                $shipmentHandler->handle($form->getData());
                $this->addFlash('success', $this->translator->trans('Shipment saved', [], 'Modules.Orlenpaczka.Tab'));
                return $this->redirectToRoute('orlenpaczka.config.shipment.index');
            }catch (\Exception $e){

            }
        }

        return $this->render('@Modules/orlenpaczka/views/templates/admin/config/tabs/shipment_type_form.html.twig', [
            'layoutTitle' => $module->displayName,
            'help_link' => false,
            'tabs' => $tabs,
            'form' => $form->createView(),
            'title' => $this->translator->trans('Shipment', [], 'Modules.Orlenpaczka.Tab'),
        ]);
    }
    /**
     * @Route("/shipment/edit/{id}", name=".edit", methods={"GET", "POST"})
     */

    public function shipmentEditAction(
        \Module $module,
        Request $request,
        Tabs $tabs,
        EntityManagerInterface $entityManager,
        ShipmentTypeTab $shipmentTypeTab,
        ShipmentHandler $shipmentHandler,
        $id

    )
    {
        $shipmentTypeTab->setUrl($this->generateUrl('orlenpaczka.config.shipment.edit', ['id' => $id]));
        $shipmentTypeTab->setActive();
        $entity = $entityManager->getRepository(Shipment::class)->find($id);


        $form = $this->createForm(ShipmentType::class, $entity);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            try{
                $shipmentHandler->handle($form->getData());
                $this->addFlash('success', $this->translator->trans('Shipment updated', [], 'Modules.Orlenpaczka.Tab'));
                return $this->redirectToRoute('orlenpaczka.config.shipment.index');
            }catch (\Exception $e){

            }

        }

        return $this->render('@Modules/orlenpaczka/views/templates/admin/config/tabs/shipment_type_form.html.twig', [
            'layoutTitle' => $module->displayName,
            'help_link' => false,
            'tabs' => $tabs,
            'form' => $form->createView(),
            'title' => $this->translator->trans('Shipment', [], 'Modules.Orlenpaczka.Tab'),
        ]);
    }
    /**
     * @Route("/shipment/delete/{id}", name=".delete", methods={"DELETE", "POST"})
     */

    public function shipmentDeleteAction(
        EntityManagerInterface $entityManager,
        ShipmentTypeTab $shipmentTypeTab,
                               $id

    )
    {
        $shipmentTypeTab->setUrl($this->generateUrl('orlenpaczka.config.shipment.delete', ['id' => $id]));
        $shipmentTypeTab->setActive();
        $entity = $entityManager->getRepository(Shipment::class)->find($id);



        $entityManager->remove($entity);
        $entityManager->flush();

        return $this->redirectToRoute('orlenpaczka.config.shipment.index');
    }
}
