<?php

namespace Orlen\OrlenPaczka\Configuration\Enum;

use Orlen\OrlenPaczka\Form\Type\AddressType;
use Orlen\OrlenPaczka\Form\Type\AuthorizationType;
use Orlen\OrlenPaczka\Form\Type\MapType;
use Orlen\OrlenPaczka\Form\Type\ShipmentType;

class ConfigFormEnum extends AbstractEnum
{
    const AUTHORIZATION = 'authorization';
    const MAP = 'map';
    const ADDRESS = 'address';
    const SHIPMENT_TYPE = 'shipment_type';

    public static function getFormByTYpe($type)
    {
        switch ($type) {
            case self::AUTHORIZATION:
                return AuthorizationType::class;
            case self::MAP:
                return MapType::class;
            case self::ADDRESS:
                return AddressType::class;
            case self::SHIPMENT_TYPE:
                return ShipmentType::class;
        }
    }
}
