<?php

namespace Orlen\OrlenPaczka\Carrier\Voter;

use Orlen\OrlenPaczka\Configuration\ConfigurationModule;
use Orlen\OrlenPaczka\Voter\Interfaces\VoterInterface;

class CarrierIsModuleVoter implements VoterInterface
{
    public const CARRIER_IS_MODULE_VOTER = 'CARRIER_IS_MODULE_VOTER';

    public function supports(string $type, $params): ?string
    {
        switch ($type) {
            case self::CARRIER_IS_MODULE_VOTER:
                return ($params instanceof \Carrier)?
                    'voteCarrierIsModule':
                    null;
            default:
                return null;
        }
    }

    public function voteCarrierIsModule(\Carrier $carrier)
    {
        return $carrier->is_module && $carrier->external_module_name === ConfigurationModule::MODULE_NAME;
    }
}
