<?php

namespace Orlen\OrlenPaczka\Authorization\Provider;

use Orlen\OrlenPaczka\Authorization\Dto\Credentials;
use Orlen\OrlenPaczka\Authorization\Dto\CredentialsInterface;
use Orlen\OrlenPaczka\Configuration\ConfigurationModule;

class CredentialsProvider implements CredentialsProviderInterface
{
    public function getCredentials(bool $sandbox): ?CredentialsInterface
    {
        $credentials = $this->getCredentialsMode($sandbox);
        $correct = $this->credentialsCorrect($credentials);

        return $correct? new Credentials($credentials['partnerId'], $credentials['partnerKey']) : null;
    }

    private function credentialsCorrect($credentials)
    {
        return !array_filter(
            $credentials,
            function($value) {
                return $value === '' || $value === null || $value === false || empty($value);
            }
        );
    }

    private function getCredentialsKeys(bool $sandbox)
    {
        return $sandbox?
            [
                ConfigurationModule::CONFIG_KEY_ORLEN_PACZKA_PARTNER_ID_SANDBOX => 'partnerId',
                ConfigurationModule::CONFIG_KEY_ORLEN_PACZKA_PARTNER_KEY_SANDBOX => 'partnerKey',
            ]
            :
            [
                ConfigurationModule::CONFIG_KEY_ORLEN_PACZKA_PARTNER_ID_PROD => 'partnerId',
                ConfigurationModule::CONFIG_KEY_ORLEN_PACZKA_PARTNER_KEY_PROD => 'partnerKey',
            ];
    }

    private function getCredentialsMode(bool $sandbox)
    {
        $configurationCredentials =\Configuration::getMultiple(array_keys($this->getCredentialsKeys($sandbox)));
        $credentials = [];
        foreach ($configurationCredentials as $key => $value) {
            $credentials[$this->getCredentialsKeys($sandbox)[$key]] = $value;
        }
        return $credentials;

    }
}
