<?php

namespace Orlen\OrlenPaczka\Authorization\Provider;

use Orlen\OrlenPaczka\Authorization\Dto\Connection;
use Orlen\OrlenPaczka\Authorization\Dto\ConnectionInterface;
use Orlen\OrlenPaczka\Configuration\ConfigurationModule;

class ConnectionProvider implements ConnectionProviderInterface
{
    private CredentialsProviderInterface $credentialsProvider;

    public function __construct(CredentialsProviderInterface $credentialsProvider)
    {
        $this->credentialsProvider = $credentialsProvider;
    }
    public function getConnection(): ConnectionInterface
    {
        $sandbox = (bool)\Configuration::get(ConfigurationModule::CONFIG_KEY_ORLEN_PACZKA_SANDBOX_MODE, null, null, null, true);
        return new Connection($sandbox, ConfigurationModule::getWsdl($sandbox), $this->credentialsProvider->getCredentials($sandbox));
    }

}
