<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class PutCustomerShippingCodeCanceled implements RequestInterface
{

    /**
     * @var string
     */
    private $ShippingCode;

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * Constructor
     *
     * @var string $ShippingCode
     * @var string $PartnerID
     * @var string $PartnerKey
     */
    public function __construct($ShippingCode, $PartnerID, $PartnerKey)
    {
        $this->ShippingCode = $ShippingCode;
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
    }

    /**
     * @return string
     */
    public function getShippingCode()
    {
        return $this->ShippingCode;
    }

    /**
     * @param string $ShippingCode
     * @return PutCustomerShippingCodeCanceled
     */
    public function withShippingCode($ShippingCode)
    {
        $new = clone $this;
        $new->ShippingCode = $ShippingCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return PutCustomerShippingCodeCanceled
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return PutCustomerShippingCodeCanceled
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }


}

