<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

class PartnerWebhookSettings
{

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $Status;

    /**
     * @var string
     */
    private $Annotation;

    /**
     * @var string
     */
    private $AuthorizationType;

    /**
     * @var string
     */
    private $UserName;

    /**
     * @var string
     */
    private $Password;

    /**
     * @var string
     */
    private $LoginUrl;

    /**
     * @var string
     */
    private $NotificationUrl;

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return PartnerWebhookSettings
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     * @param string $Status
     * @return PartnerWebhookSettings
     */
    public function withStatus($Status)
    {
        $new = clone $this;
        $new->Status = $Status;

        return $new;
    }

    /**
     * @return string
     */
    public function getAnnotation()
    {
        return $this->Annotation;
    }

    /**
     * @param string $Annotation
     * @return PartnerWebhookSettings
     */
    public function withAnnotation($Annotation)
    {
        $new = clone $this;
        $new->Annotation = $Annotation;

        return $new;
    }

    /**
     * @return string
     */
    public function getAuthorizationType()
    {
        return $this->AuthorizationType;
    }

    /**
     * @param string $AuthorizationType
     * @return PartnerWebhookSettings
     */
    public function withAuthorizationType($AuthorizationType)
    {
        $new = clone $this;
        $new->AuthorizationType = $AuthorizationType;

        return $new;
    }

    /**
     * @return string
     */
    public function getUserName()
    {
        return $this->UserName;
    }

    /**
     * @param string $UserName
     * @return PartnerWebhookSettings
     */
    public function withUserName($UserName)
    {
        $new = clone $this;
        $new->UserName = $UserName;

        return $new;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->Password;
    }

    /**
     * @param string $Password
     * @return PartnerWebhookSettings
     */
    public function withPassword($Password)
    {
        $new = clone $this;
        $new->Password = $Password;

        return $new;
    }

    /**
     * @return string
     */
    public function getLoginUrl()
    {
        return $this->LoginUrl;
    }

    /**
     * @param string $LoginUrl
     * @return PartnerWebhookSettings
     */
    public function withLoginUrl($LoginUrl)
    {
        $new = clone $this;
        $new->LoginUrl = $LoginUrl;

        return $new;
    }

    /**
     * @return string
     */
    public function getNotificationUrl()
    {
        return $this->NotificationUrl;
    }

    /**
     * @param string $NotificationUrl
     * @return PartnerWebhookSettings
     */
    public function withNotificationUrl($NotificationUrl)
    {
        $new = clone $this;
        $new->NotificationUrl = $NotificationUrl;

        return $new;
    }


}

