<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class ORLENPaczkaPointsUpdate implements RequestInterface
{

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * @var \DateTimeInterface
     */
    private $FromWhen;

    /**
     * Constructor
     *
     * @var string $PartnerID
     * @var string $PartnerKey
     * @var \DateTimeInterface $FromWhen
     */
    public function __construct($PartnerID, $PartnerKey, $FromWhen)
    {
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
        $this->FromWhen = $FromWhen;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return ORLENPaczkaPointsUpdate
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return ORLENPaczkaPointsUpdate
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getFromWhen()
    {
        return $this->FromWhen;
    }

    /**
     * @param \DateTimeInterface $FromWhen
     * @return ORLENPaczkaPointsUpdate
     */
    public function withFromWhen($FromWhen)
    {
        $new = clone $this;
        $new->FromWhen = $FromWhen;

        return $new;
    }


}

