<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class LabelPrintDuplicateTwo implements RequestInterface
{

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * @var string
     */
    private $PackCode;

    /**
     * @var string
     */
    private $Format;

    /**
     * Constructor
     *
     * @var string $PartnerID
     * @var string $PartnerKey
     * @var string $PackCode
     * @var string $Format
     */
    public function __construct($PartnerID, $PartnerKey, $PackCode, $Format)
    {
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
        $this->PackCode = $PackCode;
        $this->Format = $Format;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return LabelPrintDuplicateTwo
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return LabelPrintDuplicateTwo
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }

    /**
     * @return string
     */
    public function getPackCode()
    {
        return $this->PackCode;
    }

    /**
     * @param string $PackCode
     * @return LabelPrintDuplicateTwo
     */
    public function withPackCode($PackCode)
    {
        $new = clone $this;
        $new->PackCode = $PackCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getFormat()
    {
        return $this->Format;
    }

    /**
     * @param string $Format
     * @return LabelPrintDuplicateTwo
     */
    public function withFormat($Format)
    {
        $new = clone $this;
        $new->Format = $Format;

        return $new;
    }


}

