<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class GiveShippingCodeStatus implements RequestInterface
{

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfString
     */
    private $Codes;

    /**
     * Constructor
     *
     * @var string $PartnerID
     * @var string $PartnerKey
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfString $Codes
     */
    public function __construct($PartnerID, $PartnerKey, $Codes)
    {
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
        $this->Codes = $Codes;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return GiveShippingCodeStatus
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return GiveShippingCodeStatus
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }

    /**
     * @return \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfString
     */
    public function getCodes()
    {
        return $this->Codes;
    }

    /**
     * @param \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfString $Codes
     * @return GiveShippingCodeStatus
     */
    public function withCodes($Codes)
    {
        $new = clone $this;
        $new->Codes = $Codes;

        return $new;
    }


}

