<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class GetGeneratedParcels implements RequestInterface
{

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * @var \DateTimeInterface
     */
    private $dateFrom;

    /**
     * @var \DateTimeInterface
     */
    private $dateTo;

    /**
     * Constructor
     *
     * @var string $PartnerID
     * @var string $PartnerKey
     * @var \DateTimeInterface $dateFrom
     * @var \DateTimeInterface $dateTo
     */
    public function __construct($PartnerID, $PartnerKey, $dateFrom, $dateTo)
    {
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
        $this->dateFrom = $dateFrom;
        $this->dateTo = $dateTo;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return GetGeneratedParcels
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return GetGeneratedParcels
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getDateFrom()
    {
        return $this->dateFrom;
    }

    /**
     * @param \DateTimeInterface $dateFrom
     * @return GetGeneratedParcels
     */
    public function withDateFrom($dateFrom)
    {
        $new = clone $this;
        $new->dateFrom = $dateFrom;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getDateTo()
    {
        return $this->dateTo;
    }

    /**
     * @param \DateTimeInterface $dateTo
     * @return GetGeneratedParcels
     */
    public function withDateTo($dateTo)
    {
        $new = clone $this;
        $new->dateTo = $dateTo;

        return $new;
    }


}

