<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\ResultInterface;

class GenerateProtocolResponse implements ResultInterface
{

    /**
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateProtocolResult
     */
    private $GenerateProtocolResult;

    /**
     * @var string
     */
    private $LabelData;

    /**
     * @return \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateProtocolResult
     */
    public function getGenerateProtocolResult()
    {
        return $this->GenerateProtocolResult;
    }

    /**
     * @param \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\GenerateProtocolResult $GenerateProtocolResult
     * @return GenerateProtocolResponse
     */
    public function withGenerateProtocolResult($GenerateProtocolResult)
    {
        $new = clone $this;
        $new->GenerateProtocolResult = $GenerateProtocolResult;

        return $new;
    }

    /**
     * @return string
     */
    public function getLabelData()
    {
        return $this->LabelData;
    }

    /**
     * @param string $LabelData
     * @return GenerateProtocolResponse
     */
    public function withLabelData($LabelData)
    {
        $new = clone $this;
        $new->LabelData = $LabelData;

        return $new;
    }


}

