<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class GenerateOrlenPaczkaShippingCode implements RequestInterface
{

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * @var string
     */
    private $PhoneNumber;

    /**
     * @var string
     */
    private $Psd;

    /**
     * @var string
     */
    private $AlternativePsd;

    /**
     * @var string
     */
    private $BoxSize;

    /**
     * @var string
     */
    private $PackValue;

    /**
     * @var string
     */
    private $CashOnDelivery;

    /**
     * @var string
     */
    private $AmountCashOnDelivery;

    /**
     * @var string
     */
    private $Insurance;

    /**
     * @var string
     */
    private $EMail;

    /**
     * @var string
     */
    private $FirstName;

    /**
     * @var string
     */
    private $LastName;

    /**
     * @var string
     */
    private $CompanyName;

    /**
     * @var string
     */
    private $StreetName;

    /**
     * @var string
     */
    private $BuildingNumber;

    /**
     * @var string
     */
    private $FlatNumber;

    /**
     * @var string
     */
    private $City;

    /**
     * @var string
     */
    private $PostCode;

    /**
     * @var string
     */
    private $SenderEMail;

    /**
     * @var string
     */
    private $SenderFirstName;

    /**
     * @var string
     */
    private $SenderLastName;

    /**
     * @var string
     */
    private $SenderCompanyName;

    /**
     * @var string
     */
    private $SenderStreetName;

    /**
     * @var string
     */
    private $SenderBuildingNumber;

    /**
     * @var string
     */
    private $SenderFlatNumber;

    /**
     * @var string
     */
    private $SenderCity;

    /**
     * @var string
     */
    private $SenderPostCode;

    /**
     * @var string
     */
    private $SenderPhoneNumber;

    /**
     * @var string
     */
    private $SenderOrders;

    /**
     * @var string
     */
    private $ReturnPsd;

    /**
     * @var string
     */
    private $ReturnEMail;

    /**
     * @var string
     */
    private $ReturnFirstName;

    /**
     * @var string
     */
    private $ReturnLastName;

    /**
     * @var string
     */
    private $ReturnCompanyName;

    /**
     * @var string
     */
    private $ReturnStreetName;

    /**
     * @var string
     */
    private $ReturnBuildingNumber;

    /**
     * @var string
     */
    private $ReturnFlatNumber;

    /**
     * @var string
     */
    private $ReturnCity;

    /**
     * @var string
     */
    private $ReturnPostCode;

    /**
     * @var string
     */
    private $ReturnPhoneNumber;

    /**
     * @var string
     */
    private $ReturnPack;

    /**
     * @var string
     */
    private $TransferDescription;

    /**
     * @var string
     */
    private $PrintAdress;

    /**
     * @var string
     */
    private $ReturnAvailable;

    /**
     * @var string
     */
    private $ReturnQuantity;

    /**
     * @var string
     */
    private $AutoDestinationChange;

    /**
     * @var string
     */
    private $ConfirmTermsOfUse;

    /**
     * @var string
     */
    private $ConfirmMarketing;

    /**
     * @var string
     */
    private $CofirmMailing;

    /**
     * @var string
     */
    private $PrintType;

    /**
     * @var string
     */
    private $ExternalSenderPackageNumber;

    /**
     * @var string
     */
    private $ExternalPackageNumber;

    /**
     * @var string
     */
    private $Serwis;

    /**
     * @var string
     */
    private $ItemsInPackage;

    /**
     * Constructor
     *
     * @var string $PartnerID
     * @var string $PartnerKey
     * @var string $PhoneNumber
     * @var string $Psd
     * @var string $AlternativePsd
     * @var string $BoxSize
     * @var string $PackValue
     * @var string $CashOnDelivery
     * @var string $AmountCashOnDelivery
     * @var string $Insurance
     * @var string $EMail
     * @var string $FirstName
     * @var string $LastName
     * @var string $CompanyName
     * @var string $StreetName
     * @var string $BuildingNumber
     * @var string $FlatNumber
     * @var string $City
     * @var string $PostCode
     * @var string $SenderEMail
     * @var string $SenderFirstName
     * @var string $SenderLastName
     * @var string $SenderCompanyName
     * @var string $SenderStreetName
     * @var string $SenderBuildingNumber
     * @var string $SenderFlatNumber
     * @var string $SenderCity
     * @var string $SenderPostCode
     * @var string $SenderPhoneNumber
     * @var string $SenderOrders
     * @var string $ReturnPsd
     * @var string $ReturnEMail
     * @var string $ReturnFirstName
     * @var string $ReturnLastName
     * @var string $ReturnCompanyName
     * @var string $ReturnStreetName
     * @var string $ReturnBuildingNumber
     * @var string $ReturnFlatNumber
     * @var string $ReturnCity
     * @var string $ReturnPostCode
     * @var string $ReturnPhoneNumber
     * @var string $ReturnPack
     * @var string $TransferDescription
     * @var string $PrintAdress
     * @var string $ReturnAvailable
     * @var string $ReturnQuantity
     * @var string $AutoDestinationChange
     * @var string $ConfirmTermsOfUse
     * @var string $ConfirmMarketing
     * @var string $CofirmMailing
     * @var string $PrintType
     * @var string $ExternalSenderPackageNumber
     * @var string $ExternalPackageNumber
     * @var string $Serwis
     * @var string $ItemsInPackage
     */
    public function __construct($PartnerID, $PartnerKey, $PhoneNumber, $Psd, $AlternativePsd, $BoxSize, $PackValue, $CashOnDelivery, $AmountCashOnDelivery, $Insurance, $EMail, $FirstName, $LastName, $CompanyName, $StreetName, $BuildingNumber, $FlatNumber, $City, $PostCode, $SenderEMail, $SenderFirstName, $SenderLastName, $SenderCompanyName, $SenderStreetName, $SenderBuildingNumber, $SenderFlatNumber, $SenderCity, $SenderPostCode, $SenderPhoneNumber, $SenderOrders, $ReturnPsd, $ReturnEMail, $ReturnFirstName, $ReturnLastName, $ReturnCompanyName, $ReturnStreetName, $ReturnBuildingNumber, $ReturnFlatNumber, $ReturnCity, $ReturnPostCode, $ReturnPhoneNumber, $ReturnPack, $TransferDescription, $PrintAdress, $ReturnAvailable, $ReturnQuantity, $AutoDestinationChange, $ConfirmTermsOfUse, $ConfirmMarketing, $CofirmMailing, $PrintType, $ExternalSenderPackageNumber, $ExternalPackageNumber, $Serwis, $ItemsInPackage)
    {
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
        $this->PhoneNumber = $PhoneNumber;
        $this->Psd = $Psd;
        $this->AlternativePsd = $AlternativePsd;
        $this->BoxSize = $BoxSize;
        $this->PackValue = $PackValue;
        $this->CashOnDelivery = $CashOnDelivery;
        $this->AmountCashOnDelivery = $AmountCashOnDelivery;
        $this->Insurance = $Insurance;
        $this->EMail = $EMail;
        $this->FirstName = $FirstName;
        $this->LastName = $LastName;
        $this->CompanyName = $CompanyName;
        $this->StreetName = $StreetName;
        $this->BuildingNumber = $BuildingNumber;
        $this->FlatNumber = $FlatNumber;
        $this->City = $City;
        $this->PostCode = $PostCode;
        $this->SenderEMail = $SenderEMail;
        $this->SenderFirstName = $SenderFirstName;
        $this->SenderLastName = $SenderLastName;
        $this->SenderCompanyName = $SenderCompanyName;
        $this->SenderStreetName = $SenderStreetName;
        $this->SenderBuildingNumber = $SenderBuildingNumber;
        $this->SenderFlatNumber = $SenderFlatNumber;
        $this->SenderCity = $SenderCity;
        $this->SenderPostCode = $SenderPostCode;
        $this->SenderPhoneNumber = $SenderPhoneNumber;
        $this->SenderOrders = $SenderOrders;
        $this->ReturnPsd = $ReturnPsd;
        $this->ReturnEMail = $ReturnEMail;
        $this->ReturnFirstName = $ReturnFirstName;
        $this->ReturnLastName = $ReturnLastName;
        $this->ReturnCompanyName = $ReturnCompanyName;
        $this->ReturnStreetName = $ReturnStreetName;
        $this->ReturnBuildingNumber = $ReturnBuildingNumber;
        $this->ReturnFlatNumber = $ReturnFlatNumber;
        $this->ReturnCity = $ReturnCity;
        $this->ReturnPostCode = $ReturnPostCode;
        $this->ReturnPhoneNumber = $ReturnPhoneNumber;
        $this->ReturnPack = $ReturnPack;
        $this->TransferDescription = $TransferDescription;
        $this->PrintAdress = $PrintAdress;
        $this->ReturnAvailable = $ReturnAvailable;
        $this->ReturnQuantity = $ReturnQuantity;
        $this->AutoDestinationChange = $AutoDestinationChange;
        $this->ConfirmTermsOfUse = $ConfirmTermsOfUse;
        $this->ConfirmMarketing = $ConfirmMarketing;
        $this->CofirmMailing = $CofirmMailing;
        $this->PrintType = $PrintType;
        $this->ExternalSenderPackageNumber = $ExternalSenderPackageNumber;
        $this->ExternalPackageNumber = $ExternalPackageNumber;
        $this->Serwis = $Serwis;
        $this->ItemsInPackage = $ItemsInPackage;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }

    /**
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }

    /**
     * @param string $PhoneNumber
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withPhoneNumber($PhoneNumber)
    {
        $new = clone $this;
        $new->PhoneNumber = $PhoneNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getPsd()
    {
        return $this->Psd;
    }

    /**
     * @param string $Psd
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withPsd($Psd)
    {
        $new = clone $this;
        $new->Psd = $Psd;

        return $new;
    }

    /**
     * @return string
     */
    public function getAlternativePsd()
    {
        return $this->AlternativePsd;
    }

    /**
     * @param string $AlternativePsd
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withAlternativePsd($AlternativePsd)
    {
        $new = clone $this;
        $new->AlternativePsd = $AlternativePsd;

        return $new;
    }

    /**
     * @return string
     */
    public function getBoxSize()
    {
        return $this->BoxSize;
    }

    /**
     * @param string $BoxSize
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withBoxSize($BoxSize)
    {
        $new = clone $this;
        $new->BoxSize = $BoxSize;

        return $new;
    }

    /**
     * @return string
     */
    public function getPackValue()
    {
        return $this->PackValue;
    }

    /**
     * @param string $PackValue
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withPackValue($PackValue)
    {
        $new = clone $this;
        $new->PackValue = $PackValue;

        return $new;
    }

    /**
     * @return string
     */
    public function getCashOnDelivery()
    {
        return $this->CashOnDelivery;
    }

    /**
     * @param string $CashOnDelivery
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withCashOnDelivery($CashOnDelivery)
    {
        $new = clone $this;
        $new->CashOnDelivery = $CashOnDelivery;

        return $new;
    }

    /**
     * @return string
     */
    public function getAmountCashOnDelivery()
    {
        return $this->AmountCashOnDelivery;
    }

    /**
     * @param string $AmountCashOnDelivery
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withAmountCashOnDelivery($AmountCashOnDelivery)
    {
        $new = clone $this;
        $new->AmountCashOnDelivery = $AmountCashOnDelivery;

        return $new;
    }

    /**
     * @return string
     */
    public function getInsurance()
    {
        return $this->Insurance;
    }

    /**
     * @param string $Insurance
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withInsurance($Insurance)
    {
        $new = clone $this;
        $new->Insurance = $Insurance;

        return $new;
    }

    /**
     * @return string
     */
    public function getEMail()
    {
        return $this->EMail;
    }

    /**
     * @param string $EMail
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withEMail($EMail)
    {
        $new = clone $this;
        $new->EMail = $EMail;

        return $new;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }

    /**
     * @param string $FirstName
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withFirstName($FirstName)
    {
        $new = clone $this;
        $new->FirstName = $FirstName;

        return $new;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->LastName;
    }

    /**
     * @param string $LastName
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withLastName($LastName)
    {
        $new = clone $this;
        $new->LastName = $LastName;

        return $new;
    }

    /**
     * @return string
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }

    /**
     * @param string $CompanyName
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withCompanyName($CompanyName)
    {
        $new = clone $this;
        $new->CompanyName = $CompanyName;

        return $new;
    }

    /**
     * @return string
     */
    public function getStreetName()
    {
        return $this->StreetName;
    }

    /**
     * @param string $StreetName
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withStreetName($StreetName)
    {
        $new = clone $this;
        $new->StreetName = $StreetName;

        return $new;
    }

    /**
     * @return string
     */
    public function getBuildingNumber()
    {
        return $this->BuildingNumber;
    }

    /**
     * @param string $BuildingNumber
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withBuildingNumber($BuildingNumber)
    {
        $new = clone $this;
        $new->BuildingNumber = $BuildingNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getFlatNumber()
    {
        return $this->FlatNumber;
    }

    /**
     * @param string $FlatNumber
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withFlatNumber($FlatNumber)
    {
        $new = clone $this;
        $new->FlatNumber = $FlatNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->City;
    }

    /**
     * @param string $City
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withCity($City)
    {
        $new = clone $this;
        $new->City = $City;

        return $new;
    }

    /**
     * @return string
     */
    public function getPostCode()
    {
        return $this->PostCode;
    }

    /**
     * @param string $PostCode
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withPostCode($PostCode)
    {
        $new = clone $this;
        $new->PostCode = $PostCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderEMail()
    {
        return $this->SenderEMail;
    }

    /**
     * @param string $SenderEMail
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withSenderEMail($SenderEMail)
    {
        $new = clone $this;
        $new->SenderEMail = $SenderEMail;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderFirstName()
    {
        return $this->SenderFirstName;
    }

    /**
     * @param string $SenderFirstName
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withSenderFirstName($SenderFirstName)
    {
        $new = clone $this;
        $new->SenderFirstName = $SenderFirstName;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderLastName()
    {
        return $this->SenderLastName;
    }

    /**
     * @param string $SenderLastName
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withSenderLastName($SenderLastName)
    {
        $new = clone $this;
        $new->SenderLastName = $SenderLastName;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderCompanyName()
    {
        return $this->SenderCompanyName;
    }

    /**
     * @param string $SenderCompanyName
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withSenderCompanyName($SenderCompanyName)
    {
        $new = clone $this;
        $new->SenderCompanyName = $SenderCompanyName;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderStreetName()
    {
        return $this->SenderStreetName;
    }

    /**
     * @param string $SenderStreetName
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withSenderStreetName($SenderStreetName)
    {
        $new = clone $this;
        $new->SenderStreetName = $SenderStreetName;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderBuildingNumber()
    {
        return $this->SenderBuildingNumber;
    }

    /**
     * @param string $SenderBuildingNumber
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withSenderBuildingNumber($SenderBuildingNumber)
    {
        $new = clone $this;
        $new->SenderBuildingNumber = $SenderBuildingNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderFlatNumber()
    {
        return $this->SenderFlatNumber;
    }

    /**
     * @param string $SenderFlatNumber
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withSenderFlatNumber($SenderFlatNumber)
    {
        $new = clone $this;
        $new->SenderFlatNumber = $SenderFlatNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderCity()
    {
        return $this->SenderCity;
    }

    /**
     * @param string $SenderCity
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withSenderCity($SenderCity)
    {
        $new = clone $this;
        $new->SenderCity = $SenderCity;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderPostCode()
    {
        return $this->SenderPostCode;
    }

    /**
     * @param string $SenderPostCode
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withSenderPostCode($SenderPostCode)
    {
        $new = clone $this;
        $new->SenderPostCode = $SenderPostCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderPhoneNumber()
    {
        return $this->SenderPhoneNumber;
    }

    /**
     * @param string $SenderPhoneNumber
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withSenderPhoneNumber($SenderPhoneNumber)
    {
        $new = clone $this;
        $new->SenderPhoneNumber = $SenderPhoneNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getSenderOrders()
    {
        return $this->SenderOrders;
    }

    /**
     * @param string $SenderOrders
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withSenderOrders($SenderOrders)
    {
        $new = clone $this;
        $new->SenderOrders = $SenderOrders;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnPsd()
    {
        return $this->ReturnPsd;
    }

    /**
     * @param string $ReturnPsd
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withReturnPsd($ReturnPsd)
    {
        $new = clone $this;
        $new->ReturnPsd = $ReturnPsd;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnEMail()
    {
        return $this->ReturnEMail;
    }

    /**
     * @param string $ReturnEMail
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withReturnEMail($ReturnEMail)
    {
        $new = clone $this;
        $new->ReturnEMail = $ReturnEMail;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnFirstName()
    {
        return $this->ReturnFirstName;
    }

    /**
     * @param string $ReturnFirstName
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withReturnFirstName($ReturnFirstName)
    {
        $new = clone $this;
        $new->ReturnFirstName = $ReturnFirstName;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnLastName()
    {
        return $this->ReturnLastName;
    }

    /**
     * @param string $ReturnLastName
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withReturnLastName($ReturnLastName)
    {
        $new = clone $this;
        $new->ReturnLastName = $ReturnLastName;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCompanyName()
    {
        return $this->ReturnCompanyName;
    }

    /**
     * @param string $ReturnCompanyName
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withReturnCompanyName($ReturnCompanyName)
    {
        $new = clone $this;
        $new->ReturnCompanyName = $ReturnCompanyName;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnStreetName()
    {
        return $this->ReturnStreetName;
    }

    /**
     * @param string $ReturnStreetName
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withReturnStreetName($ReturnStreetName)
    {
        $new = clone $this;
        $new->ReturnStreetName = $ReturnStreetName;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnBuildingNumber()
    {
        return $this->ReturnBuildingNumber;
    }

    /**
     * @param string $ReturnBuildingNumber
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withReturnBuildingNumber($ReturnBuildingNumber)
    {
        $new = clone $this;
        $new->ReturnBuildingNumber = $ReturnBuildingNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnFlatNumber()
    {
        return $this->ReturnFlatNumber;
    }

    /**
     * @param string $ReturnFlatNumber
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withReturnFlatNumber($ReturnFlatNumber)
    {
        $new = clone $this;
        $new->ReturnFlatNumber = $ReturnFlatNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCity()
    {
        return $this->ReturnCity;
    }

    /**
     * @param string $ReturnCity
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withReturnCity($ReturnCity)
    {
        $new = clone $this;
        $new->ReturnCity = $ReturnCity;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnPostCode()
    {
        return $this->ReturnPostCode;
    }

    /**
     * @param string $ReturnPostCode
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withReturnPostCode($ReturnPostCode)
    {
        $new = clone $this;
        $new->ReturnPostCode = $ReturnPostCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnPhoneNumber()
    {
        return $this->ReturnPhoneNumber;
    }

    /**
     * @param string $ReturnPhoneNumber
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withReturnPhoneNumber($ReturnPhoneNumber)
    {
        $new = clone $this;
        $new->ReturnPhoneNumber = $ReturnPhoneNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnPack()
    {
        return $this->ReturnPack;
    }

    /**
     * @param string $ReturnPack
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withReturnPack($ReturnPack)
    {
        $new = clone $this;
        $new->ReturnPack = $ReturnPack;

        return $new;
    }

    /**
     * @return string
     */
    public function getTransferDescription()
    {
        return $this->TransferDescription;
    }

    /**
     * @param string $TransferDescription
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withTransferDescription($TransferDescription)
    {
        $new = clone $this;
        $new->TransferDescription = $TransferDescription;

        return $new;
    }

    /**
     * @return string
     */
    public function getPrintAdress()
    {
        return $this->PrintAdress;
    }

    /**
     * @param string $PrintAdress
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withPrintAdress($PrintAdress)
    {
        $new = clone $this;
        $new->PrintAdress = $PrintAdress;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnAvailable()
    {
        return $this->ReturnAvailable;
    }

    /**
     * @param string $ReturnAvailable
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withReturnAvailable($ReturnAvailable)
    {
        $new = clone $this;
        $new->ReturnAvailable = $ReturnAvailable;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnQuantity()
    {
        return $this->ReturnQuantity;
    }

    /**
     * @param string $ReturnQuantity
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withReturnQuantity($ReturnQuantity)
    {
        $new = clone $this;
        $new->ReturnQuantity = $ReturnQuantity;

        return $new;
    }

    /**
     * @return string
     */
    public function getAutoDestinationChange()
    {
        return $this->AutoDestinationChange;
    }

    /**
     * @param string $AutoDestinationChange
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withAutoDestinationChange($AutoDestinationChange)
    {
        $new = clone $this;
        $new->AutoDestinationChange = $AutoDestinationChange;

        return $new;
    }

    /**
     * @return string
     */
    public function getConfirmTermsOfUse()
    {
        return $this->ConfirmTermsOfUse;
    }

    /**
     * @param string $ConfirmTermsOfUse
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withConfirmTermsOfUse($ConfirmTermsOfUse)
    {
        $new = clone $this;
        $new->ConfirmTermsOfUse = $ConfirmTermsOfUse;

        return $new;
    }

    /**
     * @return string
     */
    public function getConfirmMarketing()
    {
        return $this->ConfirmMarketing;
    }

    /**
     * @param string $ConfirmMarketing
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withConfirmMarketing($ConfirmMarketing)
    {
        $new = clone $this;
        $new->ConfirmMarketing = $ConfirmMarketing;

        return $new;
    }

    /**
     * @return string
     */
    public function getCofirmMailing()
    {
        return $this->CofirmMailing;
    }

    /**
     * @param string $CofirmMailing
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withCofirmMailing($CofirmMailing)
    {
        $new = clone $this;
        $new->CofirmMailing = $CofirmMailing;

        return $new;
    }

    /**
     * @return string
     */
    public function getPrintType()
    {
        return $this->PrintType;
    }

    /**
     * @param string $PrintType
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withPrintType($PrintType)
    {
        $new = clone $this;
        $new->PrintType = $PrintType;

        return $new;
    }

    /**
     * @return string
     */
    public function getExternalSenderPackageNumber()
    {
        return $this->ExternalSenderPackageNumber;
    }

    /**
     * @param string $ExternalSenderPackageNumber
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withExternalSenderPackageNumber($ExternalSenderPackageNumber)
    {
        $new = clone $this;
        $new->ExternalSenderPackageNumber = $ExternalSenderPackageNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getExternalPackageNumber()
    {
        return $this->ExternalPackageNumber;
    }

    /**
     * @param string $ExternalPackageNumber
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withExternalPackageNumber($ExternalPackageNumber)
    {
        $new = clone $this;
        $new->ExternalPackageNumber = $ExternalPackageNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getSerwis()
    {
        return $this->Serwis;
    }

    /**
     * @param string $Serwis
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withSerwis($Serwis)
    {
        $new = clone $this;
        $new->Serwis = $Serwis;

        return $new;
    }

    /**
     * @return string
     */
    public function getItemsInPackage()
    {
        return $this->ItemsInPackage;
    }

    /**
     * @param string $ItemsInPackage
     * @return GenerateOrlenPaczkaShippingCode
     */
    public function withItemsInPackage($ItemsInPackage)
    {
        $new = clone $this;
        $new->ItemsInPackage = $ItemsInPackage;

        return $new;
    }


}

