<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class GenerateLabelBusinessPackList implements RequestInterface
{

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * @var string
     */
    private $Format;

    /**
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfBusinessPack
     */
    private $BusinessPackList;

    /**
     * Constructor
     *
     * @var string $PartnerID
     * @var string $PartnerKey
     * @var string $Format
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfBusinessPack $BusinessPackList
     */
    public function __construct($PartnerID, $PartnerKey, $Format, $BusinessPackList)
    {
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
        $this->Format = $Format;
        $this->BusinessPackList = $BusinessPackList;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return GenerateLabelBusinessPackList
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return GenerateLabelBusinessPackList
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }

    /**
     * @return string
     */
    public function getFormat()
    {
        return $this->Format;
    }

    /**
     * @param string $Format
     * @return GenerateLabelBusinessPackList
     */
    public function withFormat($Format)
    {
        $new = clone $this;
        $new->Format = $Format;

        return $new;
    }

    /**
     * @return \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfBusinessPack
     */
    public function getBusinessPackList()
    {
        return $this->BusinessPackList;
    }

    /**
     * @param \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfBusinessPack $BusinessPackList
     * @return GenerateLabelBusinessPackList
     */
    public function withBusinessPackList($BusinessPackList)
    {
        $new = clone $this;
        $new->BusinessPackList = $BusinessPackList;

        return $new;
    }


}

