<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

class DataSet
{

    /**
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\AnyXML
     */
    private $schema;

    /**
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\AnyXML
     */
    private $any;

    /**
     * @return \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\AnyXML
     */
    public function getSchema()
    {
        return $this->schema;
    }

    /**
     * @param \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\AnyXML $schema
     * @return DataSet
     */
    public function withSchema($schema)
    {
        $new = clone $this;
        $new->schema = $schema;

        return $new;
    }

    /**
     * @return \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\AnyXML
     */
    public function getAny()
    {
        return $this->any;
    }

    /**
     * @param \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\AnyXML $any
     * @return DataSet
     */
    public function withAny($any)
    {
        $new = clone $this;
        $new->any = $any;

        return $new;
    }


}

