<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class CustomerConfirmPackReturn implements RequestInterface
{

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * @var string
     */
    private $PackCode;

    /**
     * @var string
     */
    private $ScanPerson;

    /**
     * Constructor
     *
     * @var string $PartnerID
     * @var string $PartnerKey
     * @var string $PackCode
     * @var string $ScanPerson
     */
    public function __construct($PartnerID, $PartnerKey, $PackCode, $ScanPerson)
    {
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
        $this->PackCode = $PackCode;
        $this->ScanPerson = $ScanPerson;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return CustomerConfirmPackReturn
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return CustomerConfirmPackReturn
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }

    /**
     * @return string
     */
    public function getPackCode()
    {
        return $this->PackCode;
    }

    /**
     * @param string $PackCode
     * @return CustomerConfirmPackReturn
     */
    public function withPackCode($PackCode)
    {
        $new = clone $this;
        $new->PackCode = $PackCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getScanPerson()
    {
        return $this->ScanPerson;
    }

    /**
     * @param string $ScanPerson
     * @return CustomerConfirmPackReturn
     */
    public function withScanPerson($ScanPerson)
    {
        $new = clone $this;
        $new->ScanPerson = $ScanPerson;

        return $new;
    }


}

