<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class CreateCustomer implements RequestInterface
{

    /**
     * @var string
     */
    private $PartnerID;

    /**
     * @var string
     */
    private $PartnerKey;

    /**
     * @var string
     */
    private $Nip;

    /**
     * @var string
     */
    private $City;

    /**
     * @var string
     */
    private $FirstName;

    /**
     * @var string
     */
    private $LastName;

    /**
     * @var string
     */
    private $CompanyName;

    /**
     * @var string
     */
    private $StreetName;

    /**
     * @var string
     */
    private $BuildingNumber;

    /**
     * @var string
     */
    private $PostCode;

    /**
     * @var string
     */
    private $PhoneNumber;

    /**
     * @var string
     */
    private $EMail;

    /**
     * Constructor
     *
     * @var string $PartnerID
     * @var string $PartnerKey
     * @var string $Nip
     * @var string $City
     * @var string $FirstName
     * @var string $LastName
     * @var string $CompanyName
     * @var string $StreetName
     * @var string $BuildingNumber
     * @var string $PostCode
     * @var string $PhoneNumber
     * @var string $EMail
     */
    public function __construct($PartnerID, $PartnerKey, $Nip, $City, $FirstName, $LastName, $CompanyName, $StreetName, $BuildingNumber, $PostCode, $PhoneNumber, $EMail)
    {
        $this->PartnerID = $PartnerID;
        $this->PartnerKey = $PartnerKey;
        $this->Nip = $Nip;
        $this->City = $City;
        $this->FirstName = $FirstName;
        $this->LastName = $LastName;
        $this->CompanyName = $CompanyName;
        $this->StreetName = $StreetName;
        $this->BuildingNumber = $BuildingNumber;
        $this->PostCode = $PostCode;
        $this->PhoneNumber = $PhoneNumber;
        $this->EMail = $EMail;
    }

    /**
     * @return string
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }

    /**
     * @param string $PartnerID
     * @return CreateCustomer
     */
    public function withPartnerID($PartnerID)
    {
        $new = clone $this;
        $new->PartnerID = $PartnerID;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->PartnerKey;
    }

    /**
     * @param string $PartnerKey
     * @return CreateCustomer
     */
    public function withPartnerKey($PartnerKey)
    {
        $new = clone $this;
        $new->PartnerKey = $PartnerKey;

        return $new;
    }

    /**
     * @return string
     */
    public function getNip()
    {
        return $this->Nip;
    }

    /**
     * @param string $Nip
     * @return CreateCustomer
     */
    public function withNip($Nip)
    {
        $new = clone $this;
        $new->Nip = $Nip;

        return $new;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->City;
    }

    /**
     * @param string $City
     * @return CreateCustomer
     */
    public function withCity($City)
    {
        $new = clone $this;
        $new->City = $City;

        return $new;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }

    /**
     * @param string $FirstName
     * @return CreateCustomer
     */
    public function withFirstName($FirstName)
    {
        $new = clone $this;
        $new->FirstName = $FirstName;

        return $new;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->LastName;
    }

    /**
     * @param string $LastName
     * @return CreateCustomer
     */
    public function withLastName($LastName)
    {
        $new = clone $this;
        $new->LastName = $LastName;

        return $new;
    }

    /**
     * @return string
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }

    /**
     * @param string $CompanyName
     * @return CreateCustomer
     */
    public function withCompanyName($CompanyName)
    {
        $new = clone $this;
        $new->CompanyName = $CompanyName;

        return $new;
    }

    /**
     * @return string
     */
    public function getStreetName()
    {
        return $this->StreetName;
    }

    /**
     * @param string $StreetName
     * @return CreateCustomer
     */
    public function withStreetName($StreetName)
    {
        $new = clone $this;
        $new->StreetName = $StreetName;

        return $new;
    }

    /**
     * @return string
     */
    public function getBuildingNumber()
    {
        return $this->BuildingNumber;
    }

    /**
     * @param string $BuildingNumber
     * @return CreateCustomer
     */
    public function withBuildingNumber($BuildingNumber)
    {
        $new = clone $this;
        $new->BuildingNumber = $BuildingNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getPostCode()
    {
        return $this->PostCode;
    }

    /**
     * @param string $PostCode
     * @return CreateCustomer
     */
    public function withPostCode($PostCode)
    {
        $new = clone $this;
        $new->PostCode = $PostCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }

    /**
     * @param string $PhoneNumber
     * @return CreateCustomer
     */
    public function withPhoneNumber($PhoneNumber)
    {
        $new = clone $this;
        $new->PhoneNumber = $PhoneNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getEMail()
    {
        return $this->EMail;
    }

    /**
     * @param string $EMail
     * @return CreateCustomer
     */
    public function withEMail($EMail)
    {
        $new = clone $this;
        $new->EMail = $EMail;

        return $new;
    }


}

