<?php

namespace Orlen\OrlenPaczka\Api\OrlenPaczka\Type;

use Orlen\OrlenPaczka\Soap\Client\Type\RequestInterface;

class CallPickup implements RequestInterface
{

    /**
     * @var string
     */
    private $partnerId;

    /**
     * @var string
     */
    private $partnerKey;

    /**
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfString
     */
    private $packList;

    /**
     * @var \DateTimeInterface
     */
    private $readyDate;

    /**
     * @var \DateTimeInterface
     */
    private $pickupDate;

    /**
     * Constructor
     *
     * @var string $partnerId
     * @var string $partnerKey
     * @var \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfString $packList
     * @var \DateTimeInterface $readyDate
     * @var \DateTimeInterface $pickupDate
     */
    public function __construct($partnerId, $partnerKey, $packList, $readyDate, $pickupDate)
    {
        $this->partnerId = $partnerId;
        $this->partnerKey = $partnerKey;
        $this->packList = $packList;
        $this->readyDate = $readyDate;
        $this->pickupDate = $pickupDate;
    }

    /**
     * @return string
     */
    public function getPartnerId()
    {
        return $this->partnerId;
    }

    /**
     * @param string $partnerId
     * @return CallPickup
     */
    public function withPartnerId($partnerId)
    {
        $new = clone $this;
        $new->partnerId = $partnerId;

        return $new;
    }

    /**
     * @return string
     */
    public function getPartnerKey()
    {
        return $this->partnerKey;
    }

    /**
     * @param string $partnerKey
     * @return CallPickup
     */
    public function withPartnerKey($partnerKey)
    {
        $new = clone $this;
        $new->partnerKey = $partnerKey;

        return $new;
    }

    /**
     * @return \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfString
     */
    public function getPackList()
    {
        return $this->packList;
    }

    /**
     * @param \Orlen\OrlenPaczka\Api\OrlenPaczka\Type\ArrayOfString $packList
     * @return CallPickup
     */
    public function withPackList($packList)
    {
        $new = clone $this;
        $new->packList = $packList;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getReadyDate()
    {
        return $this->readyDate;
    }

    /**
     * @param \DateTimeInterface $readyDate
     * @return CallPickup
     */
    public function withReadyDate($readyDate)
    {
        $new = clone $this;
        $new->readyDate = $readyDate;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getPickupDate()
    {
        return $this->pickupDate;
    }

    /**
     * @param \DateTimeInterface $pickupDate
     * @return CallPickup
     */
    public function withPickupDate($pickupDate)
    {
        $new = clone $this;
        $new->pickupDate = $pickupDate;

        return $new;
    }


}

