<?php

use Orlen\OrlenPaczka\Configuration\ConfigurationModule;
use Orlen\OrlenPaczka\Hook\HookExecutor;
use Orlen\OrlenPaczka\Installer\ModuleInstaller;
use Orlen\OrlenPaczka\Repository\ShipmentRepository;

if(!defined('_PS_VERSION_'))
    exit;


include_once _PS_MODULE_DIR_ . 'orlenpaczka/vendor/autoload.php';

class orlenpaczka extends CarrierModule
{
    public $id_carrier = -1;

    public function __construct()
    {
        $this->name = 'orlenpaczka';
        $this->tab = 'others';
        $this->version = '1.0.1';
        $this->need_instance = 0;
        $this->bootstrap = true;
        parent::__construct();
        $this->displayName = $this->l('ORLEN Paczka');
        $this->controllers = ['default'];
        $this->ps_versions_compliancy = array('min' => '1.7.8', 'max' => _PS_VERSION_);
    }

    public function install()
    {
        $installer = new ModuleInstaller();
        $configuration = new ConfigurationModule();
        $this->setUpRoutingLoaderResolver();

        $result = parent::install() && $installer->install($configuration);

        if (80100 <= PHP_VERSION_ID) {
            return true;
        }

        try {
            /** @var \Symfony\Component\EventDispatcher\EventDispatcher $eventDispatcher */
            $eventDispatcher = $this->get('event_dispatcher');
            $eventDispatcher->addListener(\Symfony\Component\HttpKernel\KernelEvents::TERMINATE, function () {
                \Module::$_INSTANCE = [];
            }, -10000);
        } catch (\Exception $e) {
        }

        return $result;
    }

    public function uninstall()
    {
        $installer = new ModuleInstaller();
        $configuration = new ConfigurationModule();
        $result = $installer->uninstall($configuration) && parent::uninstall();

        if (80100 <= PHP_VERSION_ID) {
            return true;
        }

        try {
            /** @var \Symfony\Component\EventDispatcher\EventDispatcher $eventDispatcher */
            $eventDispatcher = $this->get('event_dispatcher');
            $eventDispatcher->addListener(\Symfony\Component\HttpKernel\KernelEvents::TERMINATE, function () {
                \Module::$_INSTANCE = [];
            }, -10000);
        } catch (\Exception $e) {
        }

        return $result;
    }

    public function __call(string $methodName, array $params)
    {
        $hookExecutor = $this->get(HookExecutor::class);

        $methodName = ucfirst(substr($methodName, 4));
        return $hookExecutor->execute($methodName, $params);
    }


    public function isUsingNewTranslationSystem()
    {
        return true;
    }


    public function getContent()
    {
        /** @var UrlGeneratorInterface $router */
        $router = $this->getContainer()->get('router');

        Tools::redirectAdmin($router->generate('orlenpaczka.config.authorization.index'));
    }

    private function setUpRoutingLoaderResolver()
    {
        if (Tools::version_compare(_PS_VERSION_, '1.7.7')) {
            return;
        }

        try {
            $this->get('routing.loader');
        } catch (Exception $e) {
            // ignore silently
        }
    }


    public function getOrderShippingCost($params, $shipping_cost)
    {
        $carrier = new \Carrier($this->id_carrier);
        $shipment = $this->get(ShipmentRepository::class)->findOneBy(['carrier' => $carrier->id_reference]);
        if (!$shipment || !$shipment->getCarrierActive()) {
            return false;
        }
        return $shipping_cost;

    }

    public function getOrderShippingCostExternal($params)
    {
        return true;
    }


}
