<?php

use Phpro\SoapClient\CodeGenerator\Assembler;
use Phpro\SoapClient\CodeGenerator\Rules;
use Phpro\SoapClient\CodeGenerator\Config\Config;
use Phpro\SoapClient\Soap\Driver\ExtSoap\ExtSoapOptions;
use Phpro\SoapClient\Soap\Driver\ExtSoap\ExtSoapEngineFactory;

return Config::create()
    ->setEngine($engine = ExtSoapEngineFactory::fromOptions(
        ExtSoapOptions::defaults('https://api-test.orlenpaczka.pl/WebServicePwR/WebServicePwR.asmx?WSDL', [])
            ->disableWsdlCache()
    ))
    ->setTypeDestination('src/Api/OrlenPaczka/Type')
    ->setTypeNamespace('Orlen\OrlenPaczka\Api\OrlenPaczka\Type')
    ->setClientDestination('src/Api/OrlenPaczka')
    ->setClientName('OrlenPaczkaClient')
    ->setClientNamespace('Orlen\OrlenPaczka\Api\OrlenPaczka')
    ->setClassMapDestination('src/Api/OrlenPaczka')
    ->setClassMapName('OrlenPaczkaClassmap')
    ->setClassMapNamespace('Orlen\OrlenPaczka\Api\OrlenPaczka')
    ->addRule(new Rules\AssembleRule(new Assembler\GetterAssembler(new Assembler\GetterAssemblerOptions())))
    ->addRule(new Rules\AssembleRule(new Assembler\ImmutableSetterAssembler(
        new Assembler\ImmutableSetterAssemblerOptions()
    )))
    ->addRule(
        new Rules\IsRequestRule(
            $engine->getMetadata(),
            new Rules\MultiRule([
                new Rules\AssembleRule(new Assembler\RequestAssembler()),
                new Rules\AssembleRule(new Assembler\ConstructorAssembler(new Assembler\ConstructorAssemblerOptions())),
            ])
        )
    )
    ->addRule(
        new Rules\IsResultRule(
            $engine->getMetadata(),
            new Rules\MultiRule([
                new Rules\AssembleRule(new Assembler\ResultAssembler()),
            ])
        )
    )
;
